<?php
/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to your theme your-theme/sysbasics-myaccount/dashboard.php , for better practice create your child theme and copy it to your-child-theme/sysbasics-myaccount/dashboard.php.
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$allowed_html = array(
	'a' => array(
		'href' => array(),
	),
);

$advanced_settings = (array) get_option( 'wcmamtx_advanced_settings' );

$hide_dashboard_hello = isset($advanced_settings['dashboard']['hide_dashboard_hello']) ? $advanced_settings['dashboard']['hide_dashboard_hello'] : 00;


if ($hide_dashboard_hello != 01) {

?>



<p>
	<?php
	printf(
		/* translators: 1: user display name 2: logout url */
		wp_kses( __( 'Hello %1$s (not %1$s? <a href="%2$s">Log out</a>)', 'woocommerce' ), $allowed_html ),
		'<strong>' . esc_html( $current_user->display_name ) . '</strong>',
		esc_url( wc_logout_url() )
	);
	?>
</p>

<?php } 

$hide_intro_hello = isset($advanced_settings['dashboard']['hide_intro_hello']) ? $advanced_settings['dashboard']['hide_intro_hello'] : 00;



if ($hide_intro_hello != 01) {

?>
<p>
	<?php
	/* translators: 1: Orders URL 2: Address URL 3: Account URL. */
	$dashboard_desc = __( 'From your account dashboard you can view your <a href="%1$s">recent orders</a>, manage your <a href="%2$s">billing address</a>, and <a href="%3$s">edit your password and account details</a>.', 'woocommerce' );
	if ( wc_shipping_enabled() ) {
		/* translators: 1: Orders URL 2: Addresses URL 3: Account URL. */
		$dashboard_desc = __( 'From your account dashboard you can view your <a href="%1$s">recent orders</a>, manage your <a href="%2$s">shipping and billing addresses</a>, and <a href="%3$s">edit your password and account details</a>.', 'woocommerce' );
	}



	printf(
		wp_kses( $dashboard_desc, $allowed_html ),
		esc_url( wc_get_endpoint_url( 'orders' ) ),
		esc_url( wc_get_endpoint_url( 'edit-address' ) ),
		esc_url( wc_get_endpoint_url( 'edit-account' ) )
	);


	?>
</p>

<?php } 



if (isset($advanced_settings['dashboard'])) {


	$content_dash = isset($advanced_settings['dashboard']['content_dash']) ? $advanced_settings['dashboard']['content_dash'] : "";

	echo apply_filters('the_content',$content_dash);

} else {

    

}

$dismiss_dash_text = get_option("wcmamtx_dismiss_dashboard_text_notice_permanately","no");

if ( current_user_can( 'administrator' )  && ($dismiss_dash_text != "yes")) {
    wcmamtx_dashboard_text_reminder_div();
}

$dismiss_dash_text2 = get_option("wcmamtx_dismiss_dashboard_text_notice_permanately2","no");

if ( current_user_can( 'administrator' )  && ($dismiss_dash_text2 != "yes")) {
    wcmamtx_dashboard_text_reminder_div2();
}

?>

<?php
	/**
	 * My Account dashboard.
	 *
	 * @since 2.6.0
	 */
	do_action( 'woocommerce_account_dashboard' );

	/**
	 * Deprecated woocommerce_before_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_before_my_account' );

	/**
	 * Deprecated woocommerce_after_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_after_my_account' );

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
